#include "../SDK/foobar2000.h"
#include "resource.h"

#include <vector>
#include <string>

using namespace std;

namespace {
	const char * const NAME = "MSN Messenger 7";
	const char * const VERSION = "mod 0.7.2.1";
	const DWORD MAGIC_NUMBER = 0x547;

	cfg_string cfg_msnformat("msnformat", "{0} - {1}");
	cfg_int cfg_db_only("db_only", 1);
}

void sendMsnMsgrMessage(HWND hMsnMsgr,
						const string& state = "0",
						const string& msnMsgrFormat = "",
						const string& title = "",
						const string& artist = "",
						const string& album = "");
void sendMusicInfo(metadb_handle* track);
void clearMusicInfo();

class play_callback_msn : public play_callback {
public:
	virtual unsigned get_callback_mask() {
		return (MASK_on_playback_new_track | MASK_on_playback_stop);
	}

	virtual void on_playback_starting() { return; }

	virtual void on_playback_new_track(metadb_handle* track) {
		if (cfg_db_only == 0 || track->handle_is_permcached()) {
			// DBȊO\ݒ
			// ܂́ADBɊ܂܂Ă
			sendMusicInfo(track);
		} else {
			clearMusicInfo();
		}
	}

	virtual void on_playback_stop(play_control::stop_reason reason) {
		if (reason != play_control::STOP_REASON_STARTING_ANOTHER) {
			// ႤȂɈڂ̂ł͂ȂSɒ~Ƃ
			clearMusicInfo();
		}
	}

	virtual void on_playback_seek(double /*time*/) { return; }
	virtual void on_playback_pause(int /*state*/) { return; }
	//currently played file got edited
	virtual void on_playback_edited(metadb_handle * /*track*/) { return; }
	virtual void on_playback_dynamic_info(const file_info * /*info*/, bool /*b_track_change*/) { return; }
};

class config_msn : public config {
	static BOOL CALLBACK ConfigProc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp) {
		switch (msg) {
		case WM_INITDIALOG:
			uSetDlgItemText(hwnd, IDC_FORMAT, cfg_msnformat);
			uSendDlgItemMessage(hwnd, IDC_DBONLY, BM_SETCHECK, cfg_db_only, 0);
			break;

		case WM_COMMAND:
			switch (wp) {
			case (EN_CHANGE << 16) | IDC_FORMAT:
				cfg_msnformat = string_utf8_from_window(reinterpret_cast<HWND>(lp));
				break;

			case IDC_DBONLY:
				cfg_db_only = uSendMessage(reinterpret_cast<HWND>(lp), BM_GETCHECK, 0, 0);
				break;
			}
			break;
		}
		return false;
	}

public:
	virtual HWND create(HWND parent) {
		return uCreateDialog(IDD_DIALOG, parent, ConfigProc);
	}
	virtual const char * get_name() { return NAME; }
	virtual const char * get_parent_name() { return "Components"; }
};

service_factory_single_t<play_callback, play_callback_msn> foo1;
service_factory_single_t<config, config_msn> foo2;

void sendMsnMsgrMessage(HWND hMsnMsgr,
						const string& state,
						const string& msnMsgrFormat,
						const string& title,
						const string& artist,
						const string& album)
{
	static const string separator("\\0");
	string musicStr = separator;
	musicStr += "Music";
	musicStr += separator; musicStr += state;
	musicStr += separator; musicStr += msnMsgrFormat;
	musicStr += separator; musicStr += title;
	musicStr += separator; musicStr += artist;
	musicStr += separator; musicStr += album;
	musicStr += separator; musicStr += "WMContentID";
	musicStr += separator;

	vector<wchar_t> w_musicStr(estimate_utf8_to_utf16(musicStr.c_str()));
	convert_utf8_to_utf16(musicStr.c_str(), &w_musicStr[0]);

	COPYDATASTRUCT msndata;
	msndata.cbData = static_cast<DWORD>(w_musicStr.size() * 2);
	msndata.dwData = MAGIC_NUMBER;
	msndata.lpData = &w_musicStr[0];

	uSendMessage(hMsnMsgr, WM_COPYDATA,
		reinterpret_cast<WPARAM>(core_api::get_main_window()),
		reinterpret_cast<LPARAM>(&msndata));
}

void sendMusicInfo(metadb_handle* track)
{
	assert(track);
	HWND hMsnMsgr = NULL;
	for (;;) {
		hMsnMsgr = FindWindowEx(NULL, hMsnMsgr, "MsnMsgrUIManager", NULL);
		if (hMsnMsgr == NULL)
			break;

		string8 artist, title, album, msnformat;

		track->handle_format_title(artist, "%ARTIST%", NULL);
		track->handle_format_title(title, "%TITLE%", NULL);
		track->handle_format_title(album, "%ALBUM%", NULL);
		track->handle_format_title(msnformat, cfg_msnformat, NULL);

		sendMsnMsgrMessage(hMsnMsgr, "1",
			msnformat.get_ptr(), title.get_ptr(), artist.get_ptr(), album.get_ptr());
	}
}

void clearMusicInfo()
{
	HWND hMsnMsgr = NULL;
	for (;;) {
		hMsnMsgr = FindWindowEx(NULL, hMsnMsgr, "MsnMsgrUIManager", NULL);
		if (hMsnMsgr == NULL)
			break;

		sendMsnMsgrMessage(hMsnMsgr);
	}
}

DECLARE_COMPONENT_VERSION(NAME, VERSION,
	"foo_msnmsgr7.dll\n"
	"Copyright (C) 2005 typester, all rights reserved.\n"
	"webpage: http://www.unknownplace.org/  email: typester@unknownplace.org\n"
	"Enhanced by http://f99aq.s57.xrea.com/");
